package router

import (
	"log"

	"net/http"
	"alpha/rhandler"
	"github.com/gorilla/mux"
	config "alpha/configuration"

)

// SetupHandlers Function for handling routes
func SetupHandlers() {
	
	log.Println("Server started")
	// Initialize router
	r := mux.NewRouter()
	
	r.HandleFunc("/", rhandler.Home).Methods("GET")
	
	r.HandleFunc("/loaderio-70552716f8f6d843afabadaedd4bec9d.txt", rhandler.Loader).Methods("GET") 
	
	r.HandleFunc("/asyncjs", rhandler.AsyncJs).Methods("GET") 
	
	r.HandleFunc("/async", rhandler.Async).Methods("GET")
	r.HandleFunc("/ajs", rhandler.Ajs).Methods("GET")
	r.HandleFunc("/iframe", rhandler.Iframe).Methods("GET")
	r.HandleFunc("/video", rhandler.Video).Methods("GET")
	
	
	// Outstream Video Ads
	r.HandleFunc("/native", rhandler.Native).Methods("GET")
	r.HandleFunc("/infeed", rhandler.Infeed).Methods("GET")
	r.HandleFunc("/inbanner", rhandler.Inbanner).Methods("GET")
	r.HandleFunc("/interstitial", rhandler.Interstitial).Methods("GET")
	r.HandleFunc("/inarticle", rhandler.Inarticle).Methods("GET")
	r.HandleFunc("/audio", rhandler.Video).Methods("GET")

	if err := http.ListenAndServe(string(config.GetConfig("portraw","app")), r); err != nil { 
		panic(err)
	}
	 
}
